<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:decimal-format decimal-separator="," grouping-separator="."/>

  <xsl:template match="/">
    <div>
      <xsl:apply-templates select="lista_plac_paski"/>
    </div>
  </xsl:template>

  <xsl:template match="lista_plac_paski">
    <div class="listaPlacPaski">
      <div class="nazwaListy">
        <xsl:value-of select="nazwa"/>
      </div>
      <xsl:apply-templates select="paski"/>
      <xsl:apply-templates select="paski_podsumowanie"/>
    </div>
  </xsl:template>

  <xsl:template match="paski">
    <div >
      <xsl:apply-templates select="pasek"/>
    </div>
  </xsl:template>

  <xsl:template match="pasek">
    <xsl:if test="position() mod 5 = 0">
      <div class="pasekLast">
        <xsl:apply-templates select="naglowek"/>
        <xsl:apply-templates select="pozycje"/>
        <xsl:apply-templates select="wyplata"/>
        <xsl:apply-templates select="dane_dodatkowe"/>
      </div>
    </xsl:if>
    <xsl:if test="position() mod 5 != 0">
      <div class="pasek">
        <xsl:apply-templates select="naglowek"/>
        <xsl:apply-templates select="pozycje"/>
        <xsl:apply-templates select="wyplata"/>
        <xsl:apply-templates select="dane_dodatkowe"/>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template match="naglowek">
    <table class="naglowek">
      <tr>
        <td>
          Nr prac: <xsl:value-of select="nr_prac"/>
        </td>
        <td class="naglowekPracownik">
          <xsl:apply-templates select="pracownik"/>
        </td>
        <td>
          <xsl:value-of select="nazwa_jednostki"/>
        </td>
        <td>
          <xsl:if test="budzet_podstawa_ser!=0">
            Płaca zas.: <xsl:value-of select="format-number(placa_zasadnicza, '0,00')"/>
          </xsl:if>
        </td>
        <td>
          Miesiąc:koszty: <xsl:apply-templates select="koszty"/>
        </td>
        <td>
          ZUS: <xsl:apply-templates select="zus"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="pracownik">
    <xsl:value-of select="nazwisko"/>&#160;<xsl:value-of select="imie"/>
  </xsl:template>

  <xsl:template match="koszty">
    <xsl:value-of select="miesiac"/> / <xsl:value-of select="rok"/>
  </xsl:template>

  <xsl:template match="zus">
    <xsl:value-of select="miesiac"/> / <xsl:value-of select="rok"/>
  </xsl:template>

  <xsl:template match="pozycje">
    <table class="pozycje" cellspacing="0" cellpadding="0">
      <xsl:apply-templates/>
    </table>
  </xsl:template>

  <xsl:template match="pozycja">
    <tr>
      <td class="grupaNazwa">
        <xsl:value-of select="nazwa_grupy"/>
      </td>
      <td class="skladniki">
        <xsl:apply-templates select="skladniki"/>
      </td>
      <td class="grupaSuma">
        <span>Razem: </span>
        <span class="grupaSumaKwota">
          <xsl:value-of select="format-number(razem, '0,00')"/>
        </span>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="skladniki">
    <xsl:apply-templates select="skladnik"/>
  </xsl:template>

  <xsl:template match="skladnik">
    <div class="skladnik">
      <div class="skladnikNazwa">
        <xsl:value-of select="nazwa_skladnika"/>
      </div>
      <div class="skladnikWartosc">
        <xsl:value-of select="format-number(wartosc_skladnika, '0,00')"/>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="wyplata">
    <table class="wyplata">
      <tr>
        <td class="wyplataRachunek">
          Rachunek bankowy: <xsl:value-of select="rachunek"/>
        </td>
        <td class="wyplataGotowka">
          Do wypłaty: Gotówka: <xsl:if test="gotowka &gt; 0">
            <xsl:value-of select="format-number(gotowka, '0,00')"/>
          </xsl:if>
        </td>
        <td class="wyplataPrzelew">
          Przelew: <xsl:if test="przelew &gt; 0">
            <xsl:value-of select="format-number(przelew, '0,00')"/>
          </xsl:if>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="dane_dodatkowe">
    <table class="daneDodatkowe">
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">Podst. podatku: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="podstawa_podatku &gt; 0">
              <xsl:value-of select="format-number(podstawa_podatku, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Koszty uzyskania:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="koszty_uzyskania &gt; 0">
              <xsl:value-of select="format-number(koszty_uzyskania, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Ulga w podatku: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="ulga_w_podatku &gt; 0">
              <xsl:value-of select="format-number(ulga_w_podatku, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Procent podatku:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:if test="procent_podatku &gt; 0">
              <xsl:value-of select="format-number(procent_podatku, '0,00')"/>
            </xsl:if>
          </span>
        </td>
      </tr>
      <xsl:if test="ulga_klasy_sredniej!=0">
        <tr>
          <td>
            <span class="daneDodatkoweNazwa">Ulga klasy średniej: </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="ulga_klasy_sredniej &gt; 0">
                <xsl:value-of select="format-number(ulga_klasy_sredniej, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>
          </td>
          <td>
          </td>
          <td>
          </td>
        </tr>
      </xsl:if>
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">Podst. ubez. em. i rent.: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="podstawa_uer &gt; 0">
              <xsl:value-of select="format-number(podstawa_uer, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Podst. ubez. chorob.:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="podstawa_uc &gt; 0">
              <xsl:value-of select="format-number(podstawa_uc, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Podst. ubez. wypad.: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="podstawa_uw &gt; 0">
              <xsl:value-of select="format-number(podstawa_uw, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Podst. ubez. zdrow.:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:if test="podstawa_uz &gt; 0">
              <xsl:value-of select="format-number(podstawa_uz, '0,00')"/>
            </xsl:if>
          </span>
        </td>
      </tr>
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">Składki finansowane przez płatnika:</span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Emerytalna:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="platnik_skladka_emerytalna &gt; 0">
              <xsl:value-of select="format-number(platnik_skladka_emerytalna, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Rentowa: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:if test="platnik_skladka_rentowa &gt; 0">
              <xsl:value-of select="format-number(platnik_skladka_rentowa, '0,00')"/>
            </xsl:if>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Wypadkowa:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:if test="platnik_skladka_wypadkowa &gt; 0">
              <xsl:value-of select="format-number(platnik_skladka_wypadkowa, '0,00')"/>
            </xsl:if>
          </span>
        </td>
      </tr>
      <xsl:if test="platnik_fep!=0 or platnik_ppk_pods!=0 or platnik_ppk_dod!=0">
        <tr>
          <td>
            <span class="daneDodatkoweNazwa">Podstawa PPK: </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="platnik_podstawa_ppk &gt; 0">
                <xsl:value-of select="format-number(platnik_podstawa_ppk, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>
            <span class="daneDodatkoweNazwa">PPK podst.: </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="platnik_ppk_pods &gt; 0">
                <xsl:value-of select="format-number(platnik_ppk_pods, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>
            <span class="daneDodatkoweNazwa">PPK dod.:</span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="platnik_ppk_dod &gt; 0">
                <xsl:value-of select="format-number(platnik_ppk_dod, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>
            <span class="daneDodatkoweNazwa">FEP: </span>
            <span class="daneDodatkoweWartoscLast">
              <xsl:if test="platnik_fep &gt; 0">
                <xsl:value-of select="format-number(platnik_fep, '0,00')"/>
              </xsl:if>
            </span>
          </td>
        </tr>
      </xsl:if>
      <xsl:if test="budzet_podstawa_ser!=0 or budzet_podstawa_sz!=0 or budzet_skladka_emerytalna!=0 or budzet_skladka_rentowa!=0 or budzet_skladka_zdrowotna!=0">
        <tr>
          <td>
            <span class="daneDodatkoweNazwa">Składki finansowane przez budżet:</span>
          </td>
          <td>
            <span class="daneDodatkoweNazwa">
              Podst. składki em.-rent.:
            </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="budzet_podstawa_ser &gt; 0">
                <xsl:value-of select="format-number(budzet_podstawa_ser, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>
            <span class="daneDodatkoweNazwa">Podst. składki zdrowotnej: </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="budzet_podstawa_sz &gt; 0">
                <xsl:value-of select="format-number(budzet_podstawa_sz, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>

          </td>
        </tr>
        <tr>
          <td>
            <span class="daneDodatkoweNazwa">
              Emerytalna:
            </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="budzet_skladka_emerytalna &gt; 0">
                <xsl:value-of select="format-number(budzet_skladka_emerytalna, '0,00')"/>
              </xsl:if >
            </span>
          </td>
          <td>
            <span class="daneDodatkoweNazwa">Rentowa: </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="budzet_skladka_rentowa &gt; 0">
                <xsl:value-of select="format-number(budzet_skladka_rentowa, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>
            <span class="daneDodatkoweNazwa">
              Zdrowotna:
            </span>
            <span class="daneDodatkoweWartosc">
              <xsl:if test="budzet_skladka_zdrowotna &gt; 0">
                <xsl:value-of select="format-number(budzet_skladka_zdrowotna, '0,00')"/>
              </xsl:if>
            </span>
          </td>
          <td>

          </td>
        </tr>
      </xsl:if>
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">NIP Płatnika: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="platnik_nip"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            PESEL Ubezpieczonego:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="pracownik_pesel"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">NFZ: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="oddzial_nfz"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Składka zdrowotna: </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:if test="budzet_skladka_zdrowotna &gt; 0">
              <xsl:value-of select="format-number(platnik_skladka_zdrowotna, '0,00')"/>
            </xsl:if>
          </span>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="paski_podsumowanie">
    <div >
      <xsl:apply-templates select="naglowek_podsumowania"/>
      <xsl:apply-templates select="pozycje_podsumowania"/>
      <xsl:apply-templates select="wyplata_podsumowania"/>
      <xsl:apply-templates select="dane_dodatkowe_podsumowania"/>
      <div class="doWyplaty">
        Do wypłaty (przelewem) słownie: <xsl:value-of select="przelew_slownie"/>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="naglowek_podsumowania">
    <div class="naglowekPodsumowaniaNaglowek">Podsumowanie</div>
    <div class="naglowekPodsumowania">
      <xsl:apply-templates select="naglowek_podsumowania_zus"/>
      <xsl:apply-templates select="naglowek_podsumowania_podatek"/>
      <xsl:apply-templates select="naglowek_podsumowania_koszty"/>
    </div>
  </xsl:template>

  <xsl:template match="naglowek_podsumowania_zus">
    <div class="naglowekPodsumowaniaPozycje">
      ZUS: <xsl:value-of select="miesiac"/> / <xsl:value-of select="rok"/>
    </div>
  </xsl:template>

  <xsl:template match="naglowek_podsumowania_podatek">
    <div class="naglowekPodsumowaniaPozycje">
      Podatek: <xsl:value-of select="miesiac"/> / <xsl:value-of select="rok"/>
    </div>
  </xsl:template>

  <xsl:template match="naglowek_podsumowania_koszty">
    <div class="naglowekPodsumowaniaPozycje">
      Miesiąc: Koszty: <xsl:value-of select="miesiac"/> / <xsl:value-of select="rok"/>
    </div>
  </xsl:template>

  <xsl:template match="pozycje_podsumowania">
    <table class="pozycje" cellspacing="0" cellpadding="0">
      <xsl:apply-templates select="pozycja_podsumowania"/>
    </table>
  </xsl:template>

  <xsl:template match="pozycja_podsumowania">
    <tr>
      <td class="grupaNazwa">
        <xsl:value-of select="nazwa_grupy_podsumowania"/>
      </td>
      <td class="skladniki">
        <xsl:apply-templates select="skladniki_podsumowania"/>
      </td>
      <td class="grupaSuma">
        <span class="grupaSumaKwota">
          <xsl:value-of select="format-number(razem_podsumowania, '0,00')"/>
        </span>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="skladniki_podsumowania">
    <xsl:apply-templates select="skladnik_podsumowania"/>
  </xsl:template>

  <xsl:template match="skladnik_podsumowania">
    <div class="skladnik">
      <div class="skladnikNazwa">
        <xsl:value-of select="nazwa_skladnika_podsumowania"/>
      </div>
      <div class="skladnikWartosc">
        <xsl:value-of select="format-number(wartosc_skladnika_podsumowania, '0,00')"/>
      </div>
    </div>
  </xsl:template>

  <xsl:template match="wyplata_podsumowania">
    <table class="wyplata">
      <tr>
        <td class="wyplataRachunek">
        </td>
        <td class="wyplataGotowka">
          Do wypłaty: Gotówka: <xsl:value-of select="format-number(gotowka, '0,00')"/>
        </td>
        <td class="wyplataPrzelew">
          Przelew: <xsl:value-of select="format-number(przelew, '0,00')"/>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template match="dane_dodatkowe_podsumowania">
    <table class="daneDodatkowe">
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">Podst. podatku: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_podatku, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Koszty uzyskania:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(koszty_uzyskania, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Ulga w podatku: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(ulga_w_podatku, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Ulga klasy średniej: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(ulga_klasy_sredniej, '0,00')"/>
          </span>
        </td>
        <td colspan="2">
        </td>
      </tr>
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">Podst. ubez. em. i rent.: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_uer, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            (zmniejszona o
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_uer_zmniejszona_o, '0,00')"/> )
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Podst. ubez. chorob.:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_uc, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Podst. ubez. wypad.: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_uw, '0,00')"/>
          </span>
        </td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            Podst. ubez. zdrow.:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:value-of select="format-number(podstawa_uz, '0,00')"/>
          </span>
        </td>
      </tr>
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">
            Podst. FP:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_fp, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Podst. FGŚP:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_fgsp, '0,00')"/>
          </span>
        </td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            Podst. u. zdr. od której składka się nie naliczyła:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(podstawa_uz_nienaliczona, '0,00')"/>
          </span>
        </td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            Podst. u. z. obl.:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:value-of select="format-number(podstawa_uz_obliczona, '0,00')"/>
          </span>
        </td>
      </tr>
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">Składki finansowane przez płatnika:</span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Emerytalna:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(platnik_skladka_emerytalna, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Rentowa: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(platnik_skladka_rentowa, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Wypadkowa:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(platnik_skladka_wypadkowa, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            FP:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:value-of select="format-number(platnik_skladka_fp, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            FGŚP:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:value-of select="format-number(platnik_skladka_fgsp, '0,00')"/>
          </span>
        </td>
      </tr>
      <tr>
        <td></td>
        <td>
          <xsl:if test="platnik_skladka_fep!=0">
            <span class="daneDodatkoweNazwa">
              FEP:
            </span>
            <span class="daneDodatkoweWartosc">
              <xsl:value-of select="format-number(platnik_skladka_fep, '0,00')"/>
            </span>
          </xsl:if>
        </td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            Składka zdrow. nie pom. do wys. podatku:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(platnik_skladka_zdrowotna_nie_pomniejszona, '0,00')"/>
          </span>
        </td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            Składka zdrow.:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:value-of select="format-number(platnik_skladka_zdrowotna, '0,00')"/>
          </span>
        </td>
      </tr>
      <tr>
        <td></td>
        <td>
          <span class="daneDodatkoweNazwa">
            Podstawa PPK:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(platnik_podstawa_skladka_ppk, '0,00')"/>
          </span>
        </td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            PPK podst.:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(platnik_skladka_ppk_pods, '0,00')"/>
          </span>
        </td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            PPK dod.:
          </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:value-of select="format-number(platnik_skladka_ppk_dod, '0,00')"/>
          </span>
        </td>
      </tr>
      <tr>
        <td>
          <span class="daneDodatkoweNazwa">Składki finansowane przez budżet:</span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Emerytalna:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(budzet_skladka_emerytalna, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">Rentowa: </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(budzet_skladka_rentowa, '0,00')"/>
          </span>
        </td>
        <td>
          <span class="daneDodatkoweNazwa">
            Zdrowotna:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(budzet_skladka_zdrowotna, '0,00')"/>
          </span>
        </td>
        <td colspan="2">

        </td>
      </tr>
      <tr>
        <td></td>
        <td colspan="2">
          <span class="daneDodatkoweNazwa">
            Podst. składki em.-rent.:
          </span>
          <span class="daneDodatkoweWartosc">
            <xsl:value-of select="format-number(budzet_podstawa_ser, '0,00')"/>
          </span>
        </td>
        <td colspan="3">
          <span class="daneDodatkoweNazwa">Podst. składki zdrowotnej: </span>
          <span class="daneDodatkoweWartoscLast">
            <xsl:value-of select="format-number(budzet_podstawa_sz, '0,00')"/>
          </span>
        </td>
      </tr>
    </table>
  </xsl:template>

</xsl:stylesheet>